// SketcherDoc.cpp : Implementacja klasy CSketcherDoc
//

#include "stdafx.h"
#include "Sketcher.h"
#include "PenDialog.h"

#include "SketcherDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CSketcherDoc

IMPLEMENT_DYNCREATE(CSketcherDoc, CDocument)

BEGIN_MESSAGE_MAP(CSketcherDoc, CDocument)
  ON_COMMAND(ID_COLOR_BLACK, &CSketcherDoc::OnColorBlack)
  ON_COMMAND(ID_COLOR_RED, &CSketcherDoc::OnColorRed)
  ON_COMMAND(ID_COLOR_GREEN, &CSketcherDoc::OnColorGreen)
  ON_COMMAND(ID_COLOR_BLUE, &CSketcherDoc::OnColorBlue)
  ON_COMMAND(ID_ELEMENT_LINE, &CSketcherDoc::OnElementLine)
  ON_COMMAND(ID_ELEMENT_RECTANGLE, &CSketcherDoc::OnElementRectangle)
  ON_COMMAND(ID_ELEMENT_CIRCLE, &CSketcherDoc::OnElementCircle)
  ON_COMMAND(ID_ELEMENT_CURVE, &CSketcherDoc::OnElementCurve)
  ON_UPDATE_COMMAND_UI(ID_COLOR_BLACK, &CSketcherDoc::OnUpdateColorBlack)
  ON_UPDATE_COMMAND_UI(ID_COLOR_RED, &CSketcherDoc::OnUpdateColorRed)
  ON_UPDATE_COMMAND_UI(ID_COLOR_GREEN, &CSketcherDoc::OnUpdateColorGreen)
  ON_UPDATE_COMMAND_UI(ID_COLOR_BLUE, &CSketcherDoc::OnUpdateColorBlue)
  ON_UPDATE_COMMAND_UI(ID_ELEMENT_LINE, &CSketcherDoc::OnUpdateElementLine)
  ON_UPDATE_COMMAND_UI(ID_ELEMENT_RECTANGLE, &CSketcherDoc::OnUpdateElementRectangle)
  ON_UPDATE_COMMAND_UI(ID_ELEMENT_CIRCLE, &CSketcherDoc::OnUpdateElementCircle)
  ON_UPDATE_COMMAND_UI(ID_ELEMENT_CURVE, &CSketcherDoc::OnUpdateElementCurve)
  ON_COMMAND(ID_PENWIDTH, &CSketcherDoc::OnPenwidth)
  ON_COMMAND(ID_ELEMENT_TEXT, &CSketcherDoc::OnElementText)
  ON_UPDATE_COMMAND_UI(ID_ELEMENT_TEXT, &CSketcherDoc::OnUpdateElementText)
END_MESSAGE_MAP()


// Konstrukcja/destrukcja CSketcherDoc

CSketcherDoc::CSketcherDoc()
: m_Element(LINE)
, m_Color(BLACK)
,m_PenWidth(0)                        // Piro o szerokoci 1 piksela
,m_DocSize(CSize(3000,3000))
{
	// TODO: add one-time construction code here

}

CSketcherDoc::~CSketcherDoc()
{
   // Pobierz pozycj z pocztku listy
   POSITION aPosition = m_ElementList.GetHeadPosition();

   // Teraz usu element wskazywany przez kolejene wpisy na licie
   while(aPosition)
      delete m_ElementList.GetNext(aPosition);

   m_ElementList.RemoveAll();   // Na koniec usu wszystkie wskaniki
}

BOOL CSketcherDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}




// Serializacja CSketcherDoc

void CSketcherDoc::Serialize(CArchive& ar)
{
  m_ElementList.Serialize(ar);         // Serializuje list elementw

  if (ar.IsStoring())
  {
    ar << m_Color                      // Zapisz biecy kolor
       << m_Element                    // biecy typ elementu
       << m_PenWidth                   // biec szeoko pira
       << m_DocSize;                   // i biecy rozmiar dokumentu
  }
  else
  {
    ar >> m_Color                      // Odczytaj biecy kolor
       >> m_Element                    // biecy typ elementu
       >> m_PenWidth                   // biec szeoko pira
       >> m_DocSize;                   // i biecy rozmiar dokumentu
  }
}


// Diagnostyka CSketcherDoc

#ifdef _DEBUG
void CSketcherDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CSketcherDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG


// CSketcherDoc commands

void CSketcherDoc::OnColorBlack()
{
     m_Color = BLACK;          // Ustawia czarny kolor rysowania
}

void CSketcherDoc::OnColorRed()
{
     m_Color = RED;          // Ustawia czerwony kolor rysowania
}

void CSketcherDoc::OnColorGreen()
{
     m_Color = GREEN;          // Ustawia zielony kolor rysowania
}

void CSketcherDoc::OnColorBlue()
{
     m_Color = BLUE;          // Ustawia niebieski kolor rysowania
}

void CSketcherDoc::OnElementLine()
{
     m_Element = LINE;         // Ustawia lini jako typ elementu
}

void CSketcherDoc::OnElementRectangle()
{
     m_Element = RECTANGLE;         // Ustawia prostokt jako typ elementu
}

void CSketcherDoc::OnElementCircle()
{
     m_Element = CIRCLE;         // Ustawia okrg jako typ elementu
}

void CSketcherDoc::OnElementCurve()
{
     m_Element = CURVE;         // Ustawia krzyw jako typ elementu
}

void CSketcherDoc::OnUpdateColorBlack(CCmdUI *pCmdUI)
{
   // Zaznacza element menu, jeeli biecym kolorem jest czarny
   pCmdUI->SetCheck(m_Color==BLACK);
}

void CSketcherDoc::OnUpdateColorRed(CCmdUI *pCmdUI)
{
   // Zaznacza element menu, jeeli biecym kolorem jest czerwony
   pCmdUI->SetCheck(m_Color==RED);
}

void CSketcherDoc::OnUpdateColorGreen(CCmdUI *pCmdUI)
{
     // Zaznacza element menu, jeeli biecym kolorem jest zielony
   pCmdUI->SetCheck(m_Color==GREEN);

}

void CSketcherDoc::OnUpdateColorBlue(CCmdUI *pCmdUI)
{
   // Zaznacza element menu, jeeli biecym kolorem jest niebieski
   pCmdUI->SetCheck(m_Color==BLUE);
}

void CSketcherDoc::OnUpdateElementLine(CCmdUI *pCmdUI)
{
     // Zaznacza element menu, jeeli biecym elementem jest okrg
   pCmdUI->SetCheck(m_Element==LINE);
}

void CSketcherDoc::OnUpdateElementRectangle(CCmdUI *pCmdUI)
{
   // Zaznacza element menu, jeeli biecym elementem jest prostokt
   pCmdUI->SetCheck(m_Element==RECTANGLE);
}

void CSketcherDoc::OnUpdateElementCircle(CCmdUI *pCmdUI)
{
   // Zaznacza element menu, jeeli biecym elementem jest okrg
   pCmdUI->SetCheck(m_Element==CIRCLE);
}

void CSketcherDoc::OnUpdateElementCurve(CCmdUI *pCmdUI)
{
   // Zaznacza element menu, jeeli biecym elementem jest krzywa
   pCmdUI->SetCheck(m_Element==CURVE);
}

void CSketcherDoc::DeleteElement(CElement* pElement)
{
  if(pElement)
  {
    // Jeeli wskanik do elementu jest poprawny,
    // znajd wskanik na licie i go usu.
    SetModifiedFlag();                 // Ustaw flag modyfikacji
    POSITION aPosition = m_ElementList.Find(pElement);
    m_ElementList.RemoveAt(aPosition);
    delete pElement;                   // Usu element ze sterty.
  }
}

void CSketcherDoc::SendToBack(CElement* pElement)
{
  if(pElement)
  {
    // Jeeli wskanik do elementu jest poprawny,
    // znajd element na licie i go usu
    POSITION aPosition = m_ElementList.Find(pElement);
    m_ElementList.RemoveAt(aPosition);

    m_ElementList.AddTail(pElement);  // Umie go na kocu listy
  }
} 

void CSketcherDoc::OnPenwidth()
{
   CPenDialog aDlg;                    // Utwrz lokalny obiekt dialogu

   // Ustawia szeroko pira in the dialog to that stored in the document
   aDlg.m_PenWidth = m_PenWidth;

   // Wywietl modalne okno dialogowe
   // Jeeli zosanie zamknite za pomoc przycsiku OK, pobierz szeroko pira
   if(aDlg.DoModal() == IDOK)
      m_PenWidth = aDlg.m_PenWidth;
}

void CSketcherDoc::OnElementText()
{
  m_Element = TEXT;
}

void CSketcherDoc::OnUpdateElementText(CCmdUI *pCmdUI)
{
  // Zaznacza element menu, jeeli biecym elementem jest tekst
  pCmdUI->SetCheck(m_Element == TEXT);
}

// Pobierz prostokt opisujcy cay dokument
CRect CSketcherDoc::GetDocExtent()
{
  CRect DocExtent(0,0,1,1);            // Pocztkowe wymiary dokumentu
  CRect ElementBound(0,0,0,0);         // Odstp dla prostokta ograniczajcego

  POSITION aPosition = m_ElementList.GetHeadPosition();

  while(aPosition)                     // Ptla przez wszystkie elementy na licie
  {
    // Pobierz prostokt ograniczajcy element
    ElementBound=(m_ElementList.GetNext(aPosition))->GetBoundRect();

    // Wsprzdne dokumentu maj ogranicza powysze
    DocExtent.UnionRect(DocExtent, ElementBound);
  }
  DocExtent.NormalizeRect();
  return DocExtent;
}
